//------------------Log
//September 25, 1995 first created.
//September 28, 1995.  Added GosperHand class, and _phase, and Permute.

#ifndef GLOCK_HPP
#define GLOCK_HPP

#include "types.h" //for <windows.h> and Real
#include "frame2.hpp"
#include "permute.hpp"
#include "point4.hpp"
#include "vector1.hpp"
#include <fstream.h>

#define TWO_PI 2.0*3.1415926

#define START_MAX_HAND_COUNT 20
#define START_TIME_STEP 0.06

#define RAND_COUNT 1 //These are flags to be ORed for GosperHand::Randomize
#define RAND_COLOR 2 //and for GosperClock::Randomize(hwnd, rand_flags)
#define RAND_RATE 4
#define RAND_LENGTH 8
#define RAND_PHASE 16
//Ordinarily we don't randomize rate as high rates make clock too fast.
#define RAND_HAND RAND_LENGTH|RAND_PHASE|RAND_COLOR
#define RAND_ALL RAND_COUNT|RAND_HAND
#define RAND_MAX_RATE 20
#define RAND_MIN_LENGTH 0.2
#define RAND_MAX_LENGTH 3.0
#define RAND_MIN_COUNT 2
#define RAND_MAX_COUNT 8

#define GC_LINE 0
#define GC_TRIANGLE 1
#define GC_SMOOTH_TRIANGLE 2
#define GC_SQUARE 3
#define GC_PENTAGON 4
#define GC_SEVEN 5
#define GC_TWELVE 6

class VectorAndPixel
{
private:
	Point _point;
	Vector2 _vector2;
public:
	VectorAndPixel(){} //Calls default constructor of _point and _vector2
	VectorAndPixel(Real x, Real y):_vector2(x,y){} //Set _vector2. _point is 0,0
	VectorAndPixel(const Vector2 &v):_vector2(v.x(), v.y()){} //_point is 0,0
	Point point(){return _point;}
	Vector2 vector2(){return _vector2;}
	int pixx(){return _point.x();}
	int pixy(){return _point.y();}
	Real x(){return _vector2.x();}
	Real y(){return _vector2.y();}
	VectorAndPixel VectorAndPixel::operator=(const VectorAndPixel &a);
	BOOL RealToPixel(const Frame &frame);
	friend VectorAndPixel operator+(const VectorAndPixel &a, const VectorAndPixel &b);
	friend VectorAndPixel operator*(Real f, const VectorAndPixel &a);
};

class GosperClock;

class GosperHand
{
private:
	friend class GosperClock;
	COLORREF _color;
	Real _rate;
	Real _length;
	Real _phase;
public:
	GosperHand(){} //Default constructor for array does nothing.
	void SetLength(Real length);
	void SetPhase(Real phase);
	void SetRate(Real rate);
	void SetColor(COLORREF color);
	void Randomize(int randomizeflags);
	friend ifstream& operator>>(ifstream& ifs, GosperClock &p);
	friend ofstream& operator<<(ofstream& ofs, GosperClock &p);
};

class GosperClock
{
private:
	Real _t;
	Real _dt;
	VectorAndPixel _center;
	int _hand_count;
	int _edit_hand_id;
	int _max_hand_count;
	GosperHand *_hand;
	VectorAndPixel *_tip;
	int _mark_count;
	int _mark_index;
	VectorAndPixel *_mark;
	int _handshape;
	int _writemode;
	int _gosper_curve;
public:
	GosperClock(int ihand_count);
	~GosperClock();
//Accessors
	Real dt(){return _dt;}
	int hand_count(){return _hand_count;}
	int handshape(){return _handshape;}
	int edit_hand_id(){return _edit_hand_id;}
	int writemode(){return _writemode;}
	Real EditHandLength();
	Real EditHandPhase();
	Real EditHandRate();
	COLORREF EditHandColor();
	int gosper_curve(){return _gosper_curve;}
//These mutators use n to decide WHICH hand to set.  Do nothing if n out of range.
	void SetGosperCurve(int code);
	BOOL SetHandCount(int n);
	void SetDt(Real newdt);
	void SetWritemode(int writemode){_writemode = writemode;}
	void SetEditHandID(int n);
	void SetHandLength(int n, Real length);
	void SetHandPhase(int n, Real phase);
	void SetHandRate(int n, Real rate);
	void SetHandColor(int n, COLORREF color);
	void SetEditHandLength(Real length){SetHandLength(_edit_hand_id, length);}
	void SetEditHandPhase(Real phase){SetHandPhase(_edit_hand_id, phase);}
	void SetEditHandRate(Real rate){SetHandRate(_edit_hand_id, rate);}
	void SetEditHandColor(COLORREF color){SetHandColor(_edit_hand_id, color);}
	void SetHandshape(int handshape);
	BOOL ChangeHandCount(int updown);
//Methods
	void SetRadius(Frame &frame); //Calls frame.SetRealWindow
	void Randomize(int randomizeflags = RAND_ALL); //Default do everything.
	void Reset();
	void Permute();
	void RealToPixel(const Frame &frame);
	void Tick();
	void Draw(HDC hdc);
	BOOL Save(char *filename);
	BOOL Open(char *filename);
	friend ifstream& operator>>(ifstream& ifs, GosperClock &p);
	friend ofstream& operator<<(ofstream& ofs, GosperClock &p);
};

#endif //GLOCK_HPP
